package com.maddox.il2.objects.air;

import com.maddox.JGP.*;
import com.maddox.il2.ai.*;
import com.maddox.il2.engine.*;
import com.maddox.il2.fm.*;
import com.maddox.rts.CLASS;
import com.maddox.rts.Property;
import com.maddox.rts.Time;
import com.maddox.il2.game.HUD;
//import com.maddox.rts.*;	// not compiled ..."normZN"... with only "com.maddox.rts.Time"
//import com.maddox.sound.Acoustics;
//import com.maddox.sound.ReverbFXRoom;

public class CockpitSpit2a extends CockpitPilot
{
    class Interpolater extends InterpolateRef
    {

        public boolean tick()
        {
            if(fm != null)
            {
                setTmp = setOld;
                setOld = setNew;
                setNew = setTmp;
                setNew.throttle = 0.97F * setOld.throttle + 0.03F * fm.CT.PowerControl;
                setNew.prop = 0.92F * setOld.prop + 0.08F * fm.EI.engines[0].getControlProp();
                setNew.mix = 0.92F * setOld.mix + 0.08F * fm.EI.engines[0].getControlMix();
                setNew.altimeter = fm.getAltitude();
//                if(Math.abs(((FlightModelMain) (fm)).Or.getKren()) < 30F)
//                    setNew.azimuth = 0.97F * setOld.azimuth + 0.03F * -((FlightModelMain) (fm)).Or.getYaw();
//                if(setOld.azimuth > 270F && setNew.azimuth < 90F)
//                    setOld.azimuth -= 360F;
//                if(setOld.azimuth < 90F && setNew.azimuth > 270F)
//                    setOld.azimuth += 360F;
//                setNew.waypointAzimuth = 0.91F * setOld.waypointAzimuth + 0.09F * (waypointAzimuth() - setOld.azimuth) + World.Rnd().nextFloat(-10F, 10F);

				if (Math.abs(fm.Or.getTangage()) < 30.0F && Math.abs(fm.Or.getKren()) < 30.0F)
					setNew.magnAzimuth.setRad(setOld.magnAzimuth.getRad(0.025F), FMMath.DEG2RAD(fm.Or.azimut()));  //NEW; magnetic
				setNew.azimuth.setDeg(setOld.azimuth.getDeg(1.0F), fm.Or.azimut());  //NEW; gyro
				setNew.waypointAzimuth.setDeg(setOld.waypointAzimuth.getDeg(1.0F), CockpitSpit2a.this.waypointAzimuth());  //NEW; waypoint

                setNew.vspeed = 0.99F * setOld.vspeed + 0.01F * fm.getVertSpeed();

				if(fm.EI.engines[0].getStage() != 0)
				{
					if(setNew.FuelPosition > 0.0F)
						setNew.FuelPosition = setOld.FuelPosition - 0.065F;
				} else
				if(setNew.FuelPosition < 1.0F)	
							setNew.FuelPosition = setOld.FuelPosition + 0.065F;

				if(cockpitDimControl)
				{
					if(setNew.dimPosition > 0.0F)
						setNew.dimPosition = setOld.dimPosition - 0.05F;
				} else
				if(setNew.dimPosition < 1.0F)
					setNew.dimPosition = setOld.dimPosition + 0.05F;
				
				float f1 = fm.EI.engines[0].getControlRadiator();
				if(f1 < enginePrevRadiator[0])
					engineRadiator[0] -= 0.10000000000000001D;
				else
				if(f1 > enginePrevRadiator[0])
					engineRadiator[0] += 0.10000000000000001D;
				else
					engineRadiator[0] *= 0.025F;	// tick delay after push knob
				if(engineRadiator[0] > 1.0F)
					engineRadiator[0] = 1.0F;
				if(engineRadiator[0] < -1F)
					engineRadiator[0] = -1F;
				enginePrevRadiator[0] = f1;
				
				buzzerFX(fm.CT.getGear() < 0.999999F && fm.CT.getFlap() > 0.0F);
			}
            return true;
        }

        Interpolater()
        {
        }
    }

    private class Variables
    {

        float throttle;
        float prop;
        float mix;
        float dimPosition;

		float FuelPosition;
        float altimeter;
//        float azimuth;
//        float waypointAzimuth;
        float vspeed;
		AnglesFork azimuth = new AnglesFork();
		AnglesFork magnAzimuth = new AnglesFork();
		AnglesFork waypointAzimuth = new AnglesFork();

        private Variables()
        {
        }

        Variables(Variables variables)
        {
            this();
        }
    }

    protected float waypointAzimuth()
    {
        WayPoint waypoint = fm.AP.way.curr();
        if(waypoint == null)
        {
            return 0.0F;
        } else
        {
            waypoint.getP(tmpP);
            tmpV.sub(tmpP, fm.Loc);
            return (float)(57.295779513082323D * Math.atan2(-((Tuple3d) (tmpV)).y, ((Tuple3d) (tmpV)).x));
        }
    }

    protected void setCameraOffset()
    {
        cameraCenter.add(0.029999999329447746D, 0.0D, 0.0D);
    }

    public CockpitSpit2a()
    {
        super("3DO/Cockpit/SpitfireMkIIa/hier.him", "bf109");
        setOld = new Variables(null);
        setNew = new Variables(null);
        w = new Vector3f();
        pictAiler = 0.0F;
		pictClap = 0.0F;
        pictElev = 0.0F;
        pictFlap = 0.0F;
        pictManf = 1.0F;
		NVoltPosition = 0.0F;
		OxyPPosition = 0.0F;
		OxyVPosition = 0.0F;
		tClap = 0;
        bNeedSetUp = true;
        tmpP = new Point3d();
        tmpV = new Vector3d();
		setNew.dimPosition = 0.0F;
		HookNamed hooknamed = new HookNamed(mesh, "LIGHT00");
        Loc loc = new Loc(0.0D, 0.0D, 0.0D, 0.0F, 0.0F, 0.0F);
        hooknamed.computePos(this, new Loc(0.0D, 0.0D, 0.0D, 0.0F, 0.0F, 0.0F), loc);
        light1 = new LightPointActor(new LightPoint(), loc.getPoint());
        light1.light.setColor(126F, 232F, 245F);
        light1.light.setEmit(0.0F, 0.0F);
        pos.base().draw.lightMap().put("LIGHT00", light1);
        hooknamed = new HookNamed(mesh, "LIGHT01");
        loc = new Loc(0.0D, 0.0D, 0.0D, 0.0F, 0.0F, 0.0F);
        hooknamed.computePos(this, new Loc(0.0D, 0.0D, 0.0D, 0.0F, 0.0F, 0.0F), loc);
        light2 = new LightPointActor(new LightPoint(), loc.getPoint());
        light2.light.setColor(126F, 232F, 245F);
        light2.light.setEmit(0.0F, 0.0F);
        pos.base().draw.lightMap().put("LIGHT01", light2);
        hooknamed = new HookNamed(mesh, "LIGHT02");
        loc = new Loc(0.0D, 0.0D, 0.0D, 0.0F, 0.0F, 0.0F);
        hooknamed.computePos(this, new Loc(0.0D, 0.0D, 0.0D, 0.0F, 0.0F, 0.0F), loc);
        light3 = new LightPointActor(new LightPoint(), loc.getPoint());
        light3.light.setColor(126F, 232F, 245F);
        light3.light.setEmit(0.0F, 0.0F);
        pos.base().draw.lightMap().put("LIGHT02", light3);
        hooknamed = new HookNamed(mesh, "LIGHT03");
        loc = new Loc(0.0D, 0.0D, 0.0D, 0.0F, 0.0F, 0.0F);
        hooknamed.computePos(this, new Loc(0.0D, 0.0D, 0.0D, 0.0F, 0.0F, 0.0F), loc);
        light4 = new LightPointActor(new LightPoint(), loc.getPoint());
        light4.light.setColor(201F, 150F, 50F);
        light4.light.setEmit(0.0F, 0.0F);
        pos.base().draw.lightMap().put("LIGHT03", light4);
        super.cockpitNightMats = (new String[] {
            "HoriDir", "needles", "SHKALA"
			});
        setNightMats(false);
        interpPut(new Interpolater(), null, Time.current(), null);
        loadBuzzerFX();
/*         if(super.acoustics != null)
            super.acoustics.globFX = new ReverbFXRoom(0.2F); */
        limits6DoF = (new float[] {
            0.7F, 0.055F, -0.07F, 0.11F, 0.15F, -0.11F, 0.04F, -0.04F
//            0.7F, 0.055F, -0.07F, 0.1F, 0.15F, -0.11F, 0.02F, -0.04F	//	Spit5B
// (0)spineL, (1)faceL, (2)spineOffsetX, (3)leanSideMax, (4)leanForwardMax, (5)leanForwardMin, (6)raiseMax, (7)raiseMin
        });
    }

    public void reflectWorldToInstruments(float f)
    {
        if(bNeedSetUp)
        {
            reflectPlaneMats();
            bNeedSetUp = false;
        }
        resetYPRmodifier();
        Cockpit.xyz[2] = cvt(fm.CT.getCockpitDoor(), 0.1F, 0.65F, 0.0F, 0.55F);
        mesh.chunkSetLocate("Canopy", Cockpit.xyz, Cockpit.ypr);
		mesh.chunkSetLocate("Canopy_E", Cockpit.xyz, Cockpit.ypr);
/* 		if(fm.getSpeed() <= 50F && fm.CT.getCockpitDoor() >= 0.73F)
		mesh.chunkSetAngles("Door", cvt(fm.CT.getCockpitDoor(), 0.73F, 0.99F, 0.0F, 145F), 0.0F, 0.0F); */
        if(fm.getSpeed() <= 50F && fm.CT.getCockpitDoor() >= 0.65F)
            mesh.chunkSetAngles("Door", cvt(fm.CT.getCockpitDoor(), 0.71F, 0.99F, 0.0F, 145F), 0.0F, 0.0F);
        mesh.chunkVisible("XLampGearUpL", fm.CT.getGear() == 0.0F);
        mesh.chunkVisible("XLampGearDownL", fm.CT.getGear() == 1.0F);
//        mesh.chunkVisible("XLampFuel", fm.M.fuel < 0.25F * fm.M.maxFuel);	//	2nd variant visible if low level
        mesh.chunkVisible("XLampFuel", fm.M.fuel < 1.0F || (fm.EI.engines[0].getRPM() < 510F));	//	visible if low pressure level
        mesh.chunkSetAngles("Z_Columnbase", 8F * (pictElev = 0.85F * pictElev + 0.15F * fm.CT.ElevatorControl), 0.0F, 0.0F);
        mesh.chunkSetAngles("Z_Column", 30F * (pictAiler = 0.85F * pictAiler + 0.15F * fm.CT.AileronControl), 0.0F, 0.0F);
        mesh.chunkSetAngles("Z_elev_rod", 14F * pictElev, 0.0F, 0.0F);
        mesh.chunkSetAngles("Z_throttle_stick", 21.6351F * interp(setNew.throttle, setOld.throttle, f), 0.0F, 0.0F);
        mesh.chunkSetAngles("Z_brake_lever", cvt(fm.CT.getBrake(), 0.0F, 1.0F, 0.0F, 19F), 0.0F, 0.0F);
        resetYPRmodifier();
        Cockpit.xyz[1] = 0.0578F * fm.CT.getRudder();
        mesh.chunkSetLocate("Pedal-L", Cockpit.xyz, Cockpit.ypr);
        Cockpit.xyz[1] = -0.0578F * fm.CT.getRudder();
        mesh.chunkSetLocate("Pedal-R", Cockpit.xyz, Cockpit.ypr);
        resetYPRmodifier();
		Cockpit.ypr[0] = cvt(fm.CT.getGear(), 0.0F, 1.0F, 138.5F, 0.0F);
        if (fm.CT.getGear() != 0.0F && fm.CT.getGear() != 1.0F)
			Cockpit.xyz[2] = 0.008F;
        else
			Cockpit.xyz[2] = 0.001F;
		mesh.chunkSetLocate("Z_Gear_lever", Cockpit.xyz, Cockpit.ypr);
//		pictGear = 0.97F * pictGear + 0.03F * fm.CT.GearControl;
//      mesh.chunkSetAngles("Z_Gear_lever", 138.5F - 138.5F * pictGear, 0.0F, 0.0F);	// need step to left
        if(fm.CT.GearControl == 0.0F && fm.CT.getGear() != 0.0F)
            mesh.chunkSetAngles("Gear_monitor", 7.0F, 0.0F, 0.0F);
        else
        if(fm.CT.GearControl == 1.0F && fm.CT.getGear() != 1.0F)
            mesh.chunkSetAngles("Gear_monitor", -7.0F, 0.0F, 0.0F);
        else
            mesh.chunkSetAngles("Gear_monitor", 0.0F, 0.0F, 0.0F);
        resetYPRmodifier();
		Cockpit.xyz[1] = fm.CT.WeaponControl[1] ? -0.003F : 0.0F;
        mesh.chunkSetLocate("Fire", Cockpit.xyz, Cockpit.ypr);
        float f2 = 0.0F;
        if(fm.CT.saveWeaponControl[0] || fm.CT.saveWeaponControl[1])
            tClap = Time.tickCounter() + World.rnd().nextInt(100, 300);
        if(Time.tickCounter() < tClap)
            f2 = 1.0F;
		mesh.chunkSetAngles("Trigger_R", 90F * (pictClap = 0.85F * pictClap + 0.15F * f2), 0.0F, 0.0F);
        mesh.chunkSetAngles("FLAP_valve", 160F * (pictFlap = 0.89F * pictFlap + 0.11F * fm.CT.FlapsControl), 0.0F, 0.0F);
        mesh.chunkSetAngles("TabElev", 1000F * fm.CT.getTrimElevatorControl(), 0.0F, 0.0F);
        mesh.chunkSetAngles("TabRud", 1000F * fm.CT.getTrimRudderControl(), 0.0F, 0.0F);
        mesh.chunkSetAngles("Pedal_plate", 20F * fm.CT.getRudder(), 0.0F, 0.0F);
		mesh.chunkSetAngles("Z_fuel_lever", cvt(interp(setNew.FuelPosition, setOld.FuelPosition, f), 0.0F, 1.0F, 45F, -39F), 0.0F, 0.0F);
        mesh.chunkSetAngles("Z_screw_lever", 90F * setNew.prop, 0.0F, 0.0F);
        mesh.chunkSetAngles("Z_mixer", 2.0F * setNew.mix, 0.0F, 0.0F);
        mesh.chunkSetAngles("SW_magneto_01", cvt(fm.EI.engines[0].getControlMagnetos() & 1, 0.0F, 1.0F, 0.0F, 75F), 0.0F, 0.0F);
        mesh.chunkSetAngles("SW_magneto_02", cvt(fm.EI.engines[0].getControlMagnetos() >> 1 & 1, 0.0F, 1.0F, 0.0F, 75F), 0.0F, 0.0F);
 		mesh.chunkSetAngles("LightArmL", 0.0F, cockpitLightControl ? -45F : 45F, 0.0F);
 		mesh.chunkSetAngles("LightArmR", 0.0F, cockpitLightControl ? -45F : 45F, 0.0F);		
		mesh.chunkSetAngles("Z_rad_lever", 15F - 30F * fm.EI.engines[0].getControlRadiator(), 0.0F, 0.0F);
        resetYPRmodifier();		
        if(engineRadiator[0] > 0.0F)
			Cockpit.xyz[0] = -0.01F;
        else
		if(engineRadiator[0] < 0.0F)
			Cockpit.xyz[0] = -0.01F;
		else
			Cockpit.xyz[0] = 0.0F;
		mesh.chunkSetLocate("rad_lock", Cockpit.xyz, Cockpit.ypr);
        resetYPRmodifier();
		Cockpit.xyz[2] = cvt(interp(setNew.dimPosition, setOld.dimPosition, f), 0.0F, 1.0F, 0.1052F, 0.0F); //U	"0.0F, 1.0F, 0.1072F, 0.0F" - litle up
		Cockpit.xyz[1] = cvt(interp(setNew.dimPosition, setOld.dimPosition, f), 0.0F, 1.0F, -0.0004F, 0.0F); //F
		mesh.chunkSetLocate("DG_box", Cockpit.xyz, Cockpit.ypr);
		mesh.chunkSetAngles("Magnet_arrow", -setNew.magnAzimuth.getDeg(0.05F) - 90.0F, 0.0F, 0.0F);  //magnetic
		mesh.chunkSetAngles("SHKALA_DIRECT", setNew.azimuth.getDeg(f) + 90.0F, 0.0F, 0.0F); //gyro
        mesh.chunkSetAngles("NeeAltim_L", -cvt(interp(setNew.altimeter, setOld.altimeter, f), 0.0F, 9144F, 0.0F, -10800F), 0.0F, 0.0F);
        mesh.chunkSetAngles("NeeAltim_S", -cvt(interp(setNew.altimeter, setOld.altimeter, f), 0.0F, 9144F, 0.0F, -1080F), 0.0F, 0.0F);
        mesh.chunkSetAngles("NeeAltim_T", -cvt(interp(setNew.altimeter, setOld.altimeter, f), 0.0F, 9144F, 0.0F, -108F), 0.0F, 0.0F);
//       mesh.chunkSetAngles("NeeBoost", cvt(pictManf = 0.91F * pictManf + 0.09F * fm.EI.engines[0].getManifoldPressure(), 0.4173668F, 3.22369F,  -110F, 240F), 0.0F, 0.0F);
		mesh.chunkSetAngles("NeeBoost", cvt(fm.EI.engines[0].getManifoldPressure(), 0.4327F, 1.80044F,  -106.5F, 232F), 0.0F, 0.0F);
/*         fBoost = fm.EI.engines[0].getManifoldPressure();
		HUD.training("Boost=" + fBoost); */
		mesh.chunkSetAngles("NeeFuel", cvt(fm.M.fuel, 0.0F, 320.0F, 0.0F, 71.2F), 0.0F, 0.0F);
        mesh.chunkSetAngles("NeeRPM", floatindex(cvt(fm.EI.engines[0].getRPM(), 1600F, 4000F, 1.0F, 13F), rpmScale), 0.0F, 0.0F);
		
/*         if (!Time.isPaused()) fTest += 0.02F * Time.speed();
        if (fTest >= 360F) fTest = 0.0F;
        HUD.training("" + fTest);
		mesh.chunkSetAngles("NeeFuel", fTest, 0F, 0F);	// for get angle - value from game gauge speedometer via hud */
		
		mesh.chunkSetAngles("NeeOilTemp", floatindex(cvt(fm.EI.engines[0].tOilOut, 0.0F, 100F, 0.0F, 10F), oilScale), 0.0F, 0.0F);
        mesh.chunkSetAngles("NeeRadTemp", floatindex(cvt(fm.EI.engines[0].tWaterOut, 40F, 150F, 4F, 15F), radScale), 0.0F, 0.0F);
		w.set(fm.getW());
		fm.Or.transform(w);
//        mesh.chunkSetAngles("NeeTurn", cvt(((Tuple3f) (w)).z, -0.23562F, 0.23562F, -48F, 48F), 0.0F, 0.0F);
        mesh.chunkSetAngles("NeeTurn", cvt(w.z, -0.23562F, 0.23562F, -48F, 48F), 0.0F, 0.0F);
        mesh.chunkSetAngles("NeeSlip", cvt(getBall(8D), -8F, 8F, 35F, -35F), 0.0F, 0.0F);
        mesh.chunkVisible("NeeASpeed_S", false);
		fSpeed = floatindex(cvt(Pitot.Indicator((float)fm.Loc.z, fm.getSpeedKMH()), 0.0F, 676.1448F, 0.0F, 21F), speedometerScale);
        mesh.chunkSetAngles("NeeASpeed_L", fSpeed, 0F, 0F);	// 1,6098686 * 420 mph =676.1448 kmh
        mesh.chunkSetAngles("NeeClimb", floatindex(cvt(setNew.vspeed, -20.02F, 20.02F, 0.0F, 8F), variometerScale), 0.0F, 0.0F);
        mesh.chunkSetAngles("NeeZenith", fm.Or.getKren(), 0.0F, 0.0F);
        resetYPRmodifier();
        Cockpit.xyz[2] = -cvt(fm.Or.getTangage(), -45F, 45F, 0.032F, -0.032F);
        mesh.chunkSetLocate("NeeHorizon", Cockpit.xyz, Cockpit.ypr);
        mesh.chunkSetAngles("NeeWatchHour", cvt(World.getTimeofDay(), 0.0F, 24F, 0.0F, 720F), 0.0F, 0.0F);
        mesh.chunkSetAngles("NeeWatchMin", cvt(World.getTimeofDay()%1, 0f, 1.0f, 0f, 360f), 0f, 0f);
        mesh.chunkSetAngles("NeeWatchSec", cvt(((World.getTimeofDay()%1)*60)%1, 0f, 1.0f, 0f, 360f), 0f, 0f);
        mesh.chunkSetAngles("NeeTrimElevat", -cvt(fm.CT.getTrimElevatorControl(), -0.5F, 0.5F, -28.53F, 28.53F), 0.0F, 0.0F);
		float f3 = 159F;
        float f4 = 206F;
		float f5 = 12F;
		if(fm.EI.engines[0].getStage() == 0)
		{
			f3 = 3F;
			f4 = 4F;
			f5 = 2F;
		}
		OxyPPosition = 0.93F * OxyPPosition + 0.07F * f3;
		mesh.chunkSetAngles("NeeOxyPress", OxyPPosition, 0.0F, 0.0F);
		OxyVPosition = 0.95F * OxyVPosition + 0.05F * f4;
		mesh.chunkSetAngles("NeeOxyVolume", OxyVPosition, 0.0F, 0.0F);
		NVoltPosition = 0.95F * NVoltPosition + 0.05F * f5;
		mesh.chunkSetAngles("NeeVoltage", NVoltPosition, 0.0F, 0.0F);
		mesh.chunkSetAngles("SW_nav_lights", fm.AS.bNavLightsOn ? 60F : 0.0F, 0.0F, 0.0F);
		if ((float)getReticleBrightness() >= 0.2)
		{
			mesh.chunkSetAngles("SW_gunsight", 55F, 0.0F, 0.0F);
			light4.light.setEmit(0.003F, 0.03F);		// (0.003F, 0.037F)
		} else
		{
			mesh.chunkSetAngles("SW_gunsight", 0.0F, 0.0F, 0.0F);
			light4.light.setEmit(0.0F, 0.0F);
		}
//		mesh.chunkSetAngles("SW_gunsight", 30F * (float)getReticleBrightness(), 0.0F, 0.0F);	// switch downing in steps 30 degrees
        if (fm.CT.bHasBrakeControl)
        {
            float f6 = fm.CT.getBrake();
            mesh.chunkSetAngles("NeeBrakeStb", cvt(f6 + f6 * fm.CT.getRudder(), 0.0F, 0.91F, 0.0F, 129F), 0.0F, 0.0F);
            mesh.chunkSetAngles("NeeBrakePrt", cvt(f6 - f6 * fm.CT.getRudder(), 0.0F, 0.88F, 0.0F, 129F), 0.0F, 0.0F);
            mesh.chunkSetAngles("NeeBrakeSup", 128F - f6 * 25F, 0.0F, 0.0F);
        }
        resetYPRmodifier();
        Cockpit.xyz[1] = -cvt(fm.EI.engines[0].getRPM(), 0.0F, 1800F, 0.0F, 0.0123F);
        mesh.chunkSetLocate("NeeOilPress", Cockpit.xyz, Cockpit.ypr);
        Cockpit.xyz[1] = -cvt(0.1F * fm.EI.engines[0].getRPM(), 0.0F, 85F, 0.0F, 0.0341F);
        mesh.chunkSetLocate("NeeFuelPress", Cockpit.xyz, Cockpit.ypr);
    }

    public void toggleDim()
    {
        cockpitDimControl = !cockpitDimControl;
    }
	
    public void reflectCockpitState()
    {
        if((fm.AS.astateCockpitState & 4) != 0)
        {
            mesh.chunkVisible("Plex_D1", true);
            mesh.chunkVisible("Bullhols1", true);
			mesh.chunkVisible("Bullhols2", true);
		}
        if((fm.AS.astateCockpitState & 8) != 0)
            mesh.chunkVisible("Blister_D1", true);
        if((fm.AS.astateCockpitState & 0x80) != 0)
		{
			mesh.chunkVisible("Blister_Oil", true);
            mesh.chunkVisible("PlexOil_D1", true);
			mesh.chunkVisible("WindowS_oil", true);
		}
        if((fm.AS.astateCockpitState & 0x10) != 0)
        {
			mesh.chunkVisible("Armorglass_D1", true);
			mesh.chunkVisible("Armorglass_D0", false);
            mesh.chunkVisible("Bullhols1", true);
			mesh.chunkVisible("Bullhols2", true);
			mesh.chunkVisible("Gunsight_gls_D1", true);
			mesh.chunkVisible("Gunsight_glass", false);
			mesh.chunkVisible("Z_Z_RETICLE", false);
		}
        if((fm.AS.astateCockpitState & 0x20) != 0)
            mesh.chunkVisible("Rearplex_D1", true);
        if((fm.AS.astateCockpitState & 0x40) != 0)
        {
            mesh.chunkVisible("Bullhols1", true);
			mesh.chunkVisible("Bullhols2", true);
            mesh.chunkVisible("Gaugls_L_D1", true);
            mesh.chunkVisible("Gaugls_R_D1", true);
            mesh.chunkVisible("NeeOxyVolume", false);
            mesh.chunkVisible("NeeASpeed_L", false);
			mesh.chunkVisible("NeeZenith", false);
			mesh.chunkVisible("NeeHorizon", false);
            mesh.chunkVisible("NeeTurn", false);
			mesh.chunkVisible("NeeSlip", false);
        }
		if((fm.AS.astateCockpitState & 1) != 0)
		{
			mesh.chunkVisible("Blister_D1", true);
			mesh.chunkVisible("Rearplex_D1", true);
        }
        if((fm.AS.astateCockpitState & 2) != 0)
        {
			mesh.chunkVisible("Armorglass_D1", true);
			mesh.chunkVisible("Armorglass_D0", false);
			mesh.chunkVisible("Plex_D1", true);
		}
        if((fm.AS.astateCockpitState & 2) != 0 && (fm.AS.astateCockpitState & 0x80) != 0)
        {
			mesh.chunkVisible("Armorglass_D1", true);
			mesh.chunkVisible("Armorglass_D0", false);
            mesh.chunkVisible("PlexHolesOil_D1", true);
			mesh.chunkVisible("Plex_D1", false);
            mesh.chunkVisible("PlexOil_D1", false);
			mesh.chunkVisible("Blister_Oil", true);
			mesh.chunkVisible("WindowS_oil", true);
		}
		if((fm.AS.astateCockpitState & 4) != 0 && (fm.AS.astateCockpitState & 0x80) != 0)
        {
            mesh.chunkVisible("PlexHolesOil_D1", true);
			mesh.chunkVisible("Plex_D1", false);
            mesh.chunkVisible("PlexOil_D1", false);
            mesh.chunkVisible("Bullhols1", true);
			mesh.chunkVisible("Bullhols2", true);
			mesh.chunkVisible("Blister_Oil", true);
			mesh.chunkVisible("WindowS_oil", true);
		}
        retoggleLight();
    }

    protected void reflectPlaneMats()
    {
        HierMesh hiermesh = aircraft().hierMesh();
        com.maddox.il2.engine.Mat mat = hiermesh.material(hiermesh.materialFind("Gloss1D0o"));
        mesh.materialReplace("Gloss1D0o", mat);
        mat = hiermesh.material(hiermesh.materialFind("Gloss1D1o"));
        mesh.materialReplace("Gloss1D1o", mat);
    }

    public void toggleLight()
    {
        cockpitLightControl = !cockpitLightControl;
        if(cockpitLightControl)
        {
			setNightMats(true);
			light1.light.setEmit(0.002F, 0.4F);
            light2.light.setEmit(0.005F, 0.5F);
            light3.light.setEmit(0.005F, 0.5F);
//			mesh.chunkVisible("****_night", true);
        } else
        {
            setNightMats(false);
            light1.light.setEmit(0.0F, 0.0F);
            light2.light.setEmit(0.0F, 0.0F);
            light3.light.setEmit(0.0F, 0.0F);
//			mesh.chunkVisible("****_night", false);
        }
    }
	
    private void retoggleLight()
    {
        if(cockpitLightControl)
        {
            setNightMats(false);
            setNightMats(true);
        } else
        {
            setNightMats(true);
            setNightMats(false);
        }
    }
	
    protected boolean doFocusEnter()
    {
        if(super.doFocusEnter())
        {
			aircraft().hierMesh().chunkVisible("Blister1_D0", false);
			aircraft().hierMesh().chunkVisible("Blister2_D0", false);
//			aircraft().hierMesh().chunkVisible("Engine1_D0", false);
//			aircraft().hierMesh().chunkVisible("CF_D0", false);
			aircraft().hierMesh().chunkVisible("Pilot1_D0", false);
			aircraft().hierMesh().chunkVisible("Head1_D0", false);
			aircraft().hierMesh().chunkVisible("HMask1_D0", false);
            return true;
        } else
		{
            return false;
        }
    }

    protected void doFocusLeave()
    {
        if(!isFocused())
        {
            return;
        } else
		{
			aircraft().hierMesh().chunkVisible("Blister1_D0", true);
			aircraft().hierMesh().chunkVisible("Blister2_D0", true);
//			aircraft().hierMesh().chunkVisible("Engine1_D0", true);
//			aircraft().hierMesh().chunkVisible("CF_D0", true);
			aircraft().hierMesh().chunkVisible("Pilot1_D0", true);
			aircraft().hierMesh().chunkVisible("Head1_D0", true);
			aircraft().hierMesh().chunkVisible("HMask1_D0", true);
            super.doFocusLeave();
            return;
		}
    }

//    private float fClimb = 0.0F;	
//    private float fBoost = 0.0F;
//    private float fRPM = 0.0F;
//    private float ftOil = 0.0F;
//    private float fBenz = 0.0F;
    private float fTest = 0.0F;
    private float fSpeed = 0.0F;
    private Variables setOld;
    private Variables setNew;
    private Variables setTmp;
    public Vector3f w;
	private LightPointActor light1;
    private LightPointActor light2;
    private LightPointActor light3;
    private LightPointActor light4;
	private float NVoltPosition;
	private float OxyPPosition;
	private float OxyVPosition;
    private float pictAiler;
    private float pictClap;
    private float pictElev;
    private float pictFlap;
    private float pictManf;
    private boolean bNeedSetUp;
	private int tClap;
	
	private float engineRadiator[] = {
        0.0F, 0.0F, 0.0F, 0.0F
    };
    private float enginePrevRadiator[] = {
        0.0F, 0.0F, 0.0F, 0.0F
    };
	
    private static final float speedometerScale[] = {
        0.0F, 6.86F, 13.7F, 21.6F, 42.2F, 65F, 92.7F, 121.1F, 154.54F, 194.4F,
        232.95F, 273.26F, 311.74F, 353F, 400.38F, 441.1F, 475F, 506.84F, 539.2F, 568.82F,
        591.65F, 614.1F
    };
    private static final float oilScale[] = {
        5.7F, 34.4F, 60.65F, 86F, 114.3F, 143F, 171.8F, 199.9F, 228.3F, 262.15F, 
        296.4F
    };
    private static final float radScale[] = {
        0.0F, 0.08F, 0.28F, 2.54F, 6.6F, 11.3F, 16.32F, 41.08F, 60.2F, 83.3F, 
        110.18F, 142.52F, 180.8F, 229F, 298.51F, 333.4F
    };
    private static final float rpmScale[] = {
		0.0F, 4.74F, 40.24F, 72.64F, 104F, 136.24F, 166.58F, 194.08F, 219.5F, 242.5F, 
        265.45F, 286.2F, 306.75F, 323F
    };
    private static final float variometerScale[] = {
        -156F, -111F, -65.5F, -32.5F, 0.0F, 32.5F, 65.5F, 111F, 156F
    };
	
    private Point3d tmpP;
    private Vector3d tmpV;

    static 
    {
//        Property.set(CLASS.THIS(), "normZN", 0.72F);
        Property.set(CLASS.THIS(), "normZNs", new float[] {	// B L F R - invisibility inside a bubble
            0.78F, 0.73F, 0.74F, 0.73F
        });
    }




}
