@echo off
set "src=Input"
set "dst=IL2_Ready"

if not exist "%src%" mkdir "%src%"
if not exist "%dst%" mkdir "%dst%"

echo === IL-2 Audio Converter: Final Polish (Voice 9.0 / Static 0.06) ===

for %%f in ("%src%\*.mp3") do (
    echo Processing: "%%~nxf"
    
    :: volume=9.0 ( 12.0)    ,   .
    :: amplitude=0.06 ( 0.03)     .
    ffmpeg -y -i "%%f" -f lavfi -i "anoisesrc=d=60:c=white:amplitude=0.06" -filter_complex "[0:a]highpass=f=600,lowpass=f=3000,compand=0.3|0.3:6:-70/-60/-20/-14:6:0:-90:0.2,volume=9.0[v]; [1:a]lowpass=f=3500[n]; [v][n]amix=inputs=2:duration=first" -f s16le -ac 1 -ar 11025 - | sox -t raw -r 11025 -c 1 -b 16 -e signed-integer - -t wavpcm "%dst%\%%~nf.wav"
)

echo.
echo === DONE! Check IL2_Ready ===
pause